/*
 *      C/C++ Run Time Library - Version 11.0
 *
 *      Copyright (c) 1993, 2004 by Borland Software Corporation
 *      All Rights Reserved.
 *
 */


/* $Revision: 9.7 $ */

    //
    // An instance of the following struct is embedded in the RTL of an
    // .EXE or .DLL for the purposes of communicating, with a debugger,
    // run-time exceptions.
    //
    // This structure can be found by locating "__DebuggerHookData" in
    // the resident names table, which contains its address.
    //

#ifdef	DIABLO

struct DebuggerData
{
        //
        // The debugger can scan memory for the following magic numbers,
        // and then grab the address of the hook function.  These also
	// serve as version numbers.
        //
	
	unsigned long	magic1;
	unsigned long	zero;
	unsigned long	magic2;

        //
        // The debugger sets a breakpoint at the code this points to, thus
        // gaining control over the child when stuff happens.
        //
	
	void * p_hook_fcn;

        //
        // The following member is modified by a debugger so as to
        // tell the run time that it is running under the control of
	// a debugger so it can inform the debugger of C++ exception
        // related events.
        //
	
	unsigned long debugger_watching;

	//
	// The following members are the "parameters" to the hook
	// function.  The debugger reads them to determine which kind
	// of C++ exception event happened.
	//

        //
        // EventKind describes what kind of C++ exception event has
        // ocurred.  The values have the following meaning:
        //
	
        //
	// EventNull :
	//
	//    Null operation, nothing to do
	//

	
	//
	// Throw, catch and destructor events:
	//
	// The following events are generated when certains exception
	// related events occur in the RTL:
	//
	//		
	// EventThrow :
	//
	//    A throw HAS ocurred. Addr points to the instruction which would
	//    have been executed if it hadn't happened.  Name points to the
	//    name of the exception thrown.  Cookie contains the cookie for
	//    this exception.  Msg may contain a pointer to a message
	//    associated with this throw (Pascal will do this). Usually this
	//    event accompanies events describing
	//    the change of the exception stack, which should occur before
	//    EventThrow is generated.
	//
	//
	// EventCatch :
	//
	//    A Catch is ABOUT to happen.  Addr points to the first instruction
	//    of the catch.  Cookie contains the cookie for this exception.
	//
	// EventDestructor :
	//
	//    A destructor is ABOUT to be called because of stack unwinding.
	//    Addr points to the first instruction of the destructor.
	//


	//
	// The following are specific to C++, describing when the termineted,
	// or unexpected functions are called.
	//
	//
	// EventUnexpected :
	//
	//    The unexpected function is about to be called.  Addr points to
	//    its address.
	//
	// EventTerminated :
	//
	//    The terminated function is about to be called.  Addr points to
	//    its address.
	//


	//
	// Pending exception stack events:
	//
	//      EventListLast
        //      EventListMore
        //      EventListEmpty
	//
	// These events describe how RTL-maintained stack of
	// pending exceptions looks.  Every time this stack is changed,
	// the RTL notifies the debugger via these events.  The
	// debugger assumes that upon startup, the list is empty, thus
	// the RTL need not notifiy the debugger of this at start up.
	// Every time the list changes, the entire list is re-described
	// to the debugger.  There are three significant ways to describe
        // the new list:
	//
	//   1) If the list has become empty, a single event of kind
	//      EventListEmpty is generated.
	//
	//   2) If the list contains a single element, a single event
	//      of kind EventListLast is generated.
	//
	//   3) If the list contains more than 1 elements N, then N - 1
	//      events of kind EventListMore is generated, followed by
	//      a single event of kind EventListLast.  The first event
	//      described the top of the stack (the most recent exception
	//      pending).
	//
	// For EventListLast and EventListMore, the following members
	// contain information about the element in the list:
	//
	//    name : contains the name of the exception being thrown/raised
	//
	//  cookie : contains an opaque handle representing the element in
	//           the list.  This should remain constant for elements in
        //           the stack which are unchanged between stack changes.
	//
	//    addr : contains a pointer to the object being thrown/raised.
	//           This should not be confused with the cookie, which is
	//           usually a pointer to the RTL's internal data structure
	//           representing the element on it's stack.
	//
	//

	
        enum EventKind { EventNull, EventThrow, EventCatch, EventDestructor,
	                 EventUnexpected, EventTerminated,
	                 EventExcept, EventFinally,
	                 EventFilter,
	                 EventListLast, EventListMore, EventListEmpty,
			 EventRawExceptionStart, EventRawExceptionFinish };
	
	EventKind kind;
	
	unsigned long	addr;
	void *		objectAddr;
	unsigned long	cookie;

	    //
	    // Strings are not neccesarily null terminated.
	    //
	
	unsigned long	name_len;
	char *		name;

	unsigned long	msg_len;
	char *		msg;
	
	    //
	    // The following is used for "raw" exceptions only
	    //
	
	unsigned long	exception_num; // non C++ exceptions only

	void *		reserved[16];
};

#endif

#ifdef	PRONTODEBUGGER
#define _DELPHI_DEBUGGER_XCPT_CODE 0xEEDFAE6

// To enable debugger tracing, the debugger finds the address of
// ___CPPdebugHook (an exported variable) and writes a "2" there.
// When the RTL has a notification to provide to the debugger, it
// will raise a nested exception _DELPHI_DEBUGGER_XCPT_CODE.
// the debugger should then look at the exception parameters, the first
// one will be one of the following:

enum	XXdebuggerNotification
{
// Destructor about to be called
// Params:
//	0:   XXDNdtor
//	1:   0
//	2:   address of destructor
//	3:   name of class, not 0-terminated
//	4:   length of class name
	XXDNdtor	   = 0,

// Exception about to be thrown
// Params:
//	0:   XXDNthrow
//	1:   0
//	2:   address where exception was thrown
//	3:   name of type being thrown, not 0-terminated
//	4:   length of name
//	5:   address object being thrown
//	6:   user EAX
//	7:   user EBX
//	8:   user EDX
//	9:   user EDI
//	10:  user ESI
//	11:  user EBP
//	12:  user ESP
	XXDNthrow	   = 1,


// FIXME: what, precisely is a raw exception?  seems to be a exception
// not in the range [0xeedface,0xeefface].  need to checkthis more
// closely.
// --xmsb (2003-4-25 17:52)
// Params:
//	0: XXDNrawException
//	1: 0
//	2: address of exception registration record
//	3: address of Win32 EXCEPTION_RECORD
//	4: address of Win32 CONTEXT
	XXDNrawException   = 2,


// A catch handler is about to be entered.
// Params:
//	0: XXDNcatch
//	1: 0
//	2: address of the handler
//	3: name of type being caught, not 0-terminated
//	4: length of that name
//	5: exception object
	XXDNcatch	   = 3,

// terminate is about to be called
// Params:
//	0: XXDNterminated
//	1: 0
//	2: address of terminate function
	XXDNterminated	   = 4,

// unexpected is about to be called
// Params:
//	0: XXDNunexpected
//	1: 0
//	2: address of unexepected handler
	XXDNunexpected	   = 5,

// a catch block is being exited
// Params:
//	0: XXDNcatchTerminate
//	1: 0
//	2: some address
	XXDNcatchTerminate = 6,
};
#endif

